<?php
/**
 * tsina Widget
 * @package WordPress
 * @subpackage runback
 */

class wheatv_sina extends WP_Widget {
   function wheatv_sina() {
		$widget_ops = array('description' => '将最近的新浪微博显示到主题中.' );
		parent::WP_Widget(false, __('WheatV: Sina微博', 'wheatv'),$widget_ops);      
	}
	
   function widget($args, $instance) {
        extract( $args );
		$title = apply_filters('widget_title', $instance['title'] );
		$id = $instance['id'];
		$num = $instance['num'];
		
		echo $before_widget;
		echo $before_title; 
		_e($title,'wheatv');
		echo $after_title;
		?>
         <ul>
			   <?php 
                $feed = fetch_feed(get_bloginfo('template_url').'/functions/sinarss2.php?id='.$id); 
                $items = $feed->get_items(0,$num); 
                foreach($items as $item) { 
                echo'<li><a target="_blank" href="'.$item->get_link().'">'.$item->get_title().'...</a></li>'; 
                } 
               ?>
         </ul>
        <?php
		echo $after_widget;
   }
   
   function update($new_instance, $old_instance) {
	   $instance['title'] = strip_tags( $new_instance['title'] );
	   $instance['id'] = strip_tags($new_instance['id']);
	   $instance['num'] = strip_tags($new_instance['num']);                
       return $instance;
   }
   function form($instance) {  
	   $defaults = array( 'title' => __('新浪微博', '新浪微博'),'num' => '5');
	   $instance = wp_parse_args( (array) $instance, $defaults ); 
		
	   $id = esc_attr($instance['id']);
	   $title = esc_attr($instance['title']);
	   $num = esc_attr($instance['num']);
   ?>
    <p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('标题:', 'wheatv'); ?></label>
		<input type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $title; ?>" />
	</p>
    <p>
        <label for="<?php echo $this->get_field_id('id'); ?>"><?php _e('新浪帐号的ID:','wheatv'); ?> </label>
        <input type="text" name="<?php echo $this->get_field_name('id'); ?>" value="<?php echo $id; ?>" id="<?php echo $this->get_field_id('id'); ?>" />
    </p>
    <p>
        <label for="<?php echo $this->get_field_id('num'); ?>"><?php _e('显示微博数:','wheatv'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('num'); ?>" value="<?php echo $num; ?>" id="<?php echo $this->get_field_id('num'); ?>" />
    </p>
   <?php
   }
}
register_widget('wheatv_sina');
?>