<?php
/**
 * Random artices Widgets
 * @package WordPress
 * @subpackage runback
 */
class wheatv_random extends WP_Widget {
   function wheatv_random() {
		$widget_ops = array('description' => '随机显示文章.' );
		parent::WP_Widget(false, __('WheatV: 随机文章', 'wheatv'),$widget_ops);      
	}
	
   function widget($args, $instance) {
        extract( $args );
		$title = apply_filters('widget_title', $instance['title'] );
		$post_num = $instance['post_num'];
                $cat= $instance['cat'];
		
		echo $before_widget;
		echo $before_title;
		_e($title,'wheatv');
		echo $after_title;
		?>
         <?php //自定义样式部分，PHP部分请不要改动?>
         <div class="pop">
            	<?php
		  query_posts('orderby=rand&order=DESC&showposts='.$post_num.'&category_name='.wheatv_get_cat_slug($cat));
		  while(have_posts()) : the_post(); ?>
                    <dl>
                    <?php if(has_post_thumbnail()):?>
                        <dt><a href="<?php the_permalink(); ?>" title="<?php the_title();?>"><?php the_post_thumbnail(array(50,50));?></a></dt>
                     <?php else:?>
                    <?php
                            $Content = $post->post_content;
                            $Images = '~<img [^\>]*\ />~';
                            preg_match_all( $Images, $Content, $thePics );
                            $allPics = count($thePics[0]);
                            switch ( $allPics > 0 ) {
                                case $allPics = 1;
                                echo'<dt><a href="'.get_permalink().'" class="thumbnail">'.$thePics[0][0].'</a></dt>';
                                break;
                                default:
                                echo'<dt><a href="'.get_permalink().'" class="thumbnail"><img src="'.get_bloginfo('template_url').'/images/no2.jpg" /></a></dt>';
                            };
                    ?>
                    <?php endif;?>
                        <dd>
                            <div class="poptitle"><a href="<?php the_permalink(); ?>" title="<?php the_title();?>">
					<?php the_title();?></a></div>
                             <span><?php the_date_xml();?> / <?php comments_popup_link(__('0', 'runback'), __('1', 'runback'), __('%', 'runback'), '', __('评论关闭', 'runback') ); ?>人评论过</span>
                            <a href="<?php the_permalink(); ?>">详细内容</a>
                        </dd>
                    </dl>
				 <?php endwhile; 
				 wp_reset_query();
				 ?>
                <div class="clear"></div>
            </div>
        <?php //自定义样式部分结束?>
        <?php
		echo $after_widget;
   }
   
   function update($new_instance, $old_instance) {
	   $instance['title'] = strip_tags( $new_instance['title'] );
           $instance['cat'] = strip_tags( $new_instance['cat'] );
	   $instance['post_num'] = strip_tags($new_instance['post_num']);                
       return $instance;
   }
   function form($instance) {  
	   $defaults = array( 'title' => __('热评文章', '热评文章'),'post_num' => '4');
	   $instance = wp_parse_args( (array) $instance, $defaults ); 
		
	   $title = esc_attr($instance['title']);
           $cat = esc_attr($instance['cat']);
	   $post_num = esc_attr($instance['post_num']);
   ?>
    <p>
	<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('栏目标题', 'wheatv'); ?></label>
	<input type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $title; ?>" />
    </p>
    
      <p>
            <label for="<?php echo $this->get_field_id('cat'); ?>"><?php _e('所属分类:','wheatv'); ?></label>
            <select name="<?php echo $this->get_field_name('cat'); ?>" class="widefat" id="<?php echo $this->get_field_id('cat'); ?>">
                <?php 
                $thecatlist_A = get_categories('hide_empty=0');
                $catdlist = array();
                foreach ($thecatlist_A as $catforlist){ 
                $cate_name = $catforlist->cat_name;
                ?>
                <option value="<?php echo $cate_name;?>" <?php if($category == $cate_name){ echo "selected='selected'";} ?>><?php echo $cate_name; ?></option>   
                <?php }?>       
            </select>
     </p>
   
    <p>
        <label for="<?php echo $this->get_field_id('post_num'); ?>"><?php _e('显示文章数','wheatv'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('post_num'); ?>" value="<?php echo $post_num; ?>" id="<?php echo $this->get_field_id('post_num'); ?>" />
    </p>
   <?php
   }
}
register_widget('wheatv_random');
?>