<?php
/**
 * Comments Widget
 * @package WordPress
 * @subpackage runback
 */

class wheatv_comments extends WP_Widget {
   function wheatv_comments() {
		$widget_ops = array('description' => '显示最新评论内容.' );
		parent::WP_Widget(false, __('WheatV: 最近评论', 'wheatv'),$widget_ops);      
	}
	
   function widget($args, $instance) {
        extract( $args );
		$title = apply_filters('widget_title', $instance['title'] );
		$num = $instance['num'];
		
		echo $before_widget;
		echo $before_title; 
		_e($title,'wheatv');
		echo $after_title;
		?>
        <div class="com">
            	<ul>
                	 <?php    global $wpdb;    $sql = "SELECT DISTINCT ID, post_title, post_password, comment_ID,    comment_post_ID, comment_author, comment_date_gmt, comment_approved,    comment_type,comment_author_url,    SUBSTRING(comment_content,1,52) AS com_excerpt    FROM $wpdb->comments    LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID =    $wpdb->posts.ID)    WHERE comment_approved = '1' AND comment_type = '' AND   post_password = '' AND comment_author not in('admin') ORDER BY comment_date_gmt DESC LIMIT ".$num;    $comments = $wpdb->get_results($sql);    $output = $pre_HTML;    $output .= "";    foreach ($comments as $comment) {    $output .= "\n<li>"."\n<b>".strip_tags($comment->comment_author)."</b>: " . "<a href=\"" . get_permalink($comment->ID) .    "#comment-" . $comment->comment_ID . "\" title=\"on " .    $comment->post_title . "\">" . strip_tags($comment->com_excerpt)    ."</a></li>";    }    $output .= "";    $output .= $post_HTML;    echo $output;    ?>
                </ul>
        </div>
        <?php
		echo $after_widget;
   }
   
   function update($new_instance, $old_instance) {
	   $instance['title'] = strip_tags( $new_instance['title'] );
	   $instance['num'] = strip_tags($new_instance['num']);                
       return $instance;
   }
   function form($instance) {  
	   $defaults = array( 'title' => __('最近评论', '最近评论'),'num' => '5');
	   $instance = wp_parse_args( (array) $instance, $defaults ); 
		
	   $title = esc_attr($instance['title']);
	   $num = esc_attr($instance['num']);
   ?>
    <p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('标题:', 'wheatv'); ?></label>
		<input type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $title; ?>" />
	</p>
    <p>
        <label for="<?php echo $this->get_field_id('num'); ?>"><?php _e('显示评论数:','wheatv'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('num'); ?>" value="<?php echo $num; ?>" id="<?php echo $this->get_field_id('num'); ?>" />
    </p>
   <?php
   }
}
register_widget('wheatv_comments');
?>