<?php
/**
 * Category articles Widget
 * @package WordPress
 * @subpackage runback
 */

class wheatv_category_articles extends WP_Widget {
   function wheatv_category_articles() {
		$widget_ops = array('description' => '显示指定分类内容.' );
		parent::WP_Widget(false, __('WheatV: 分类文章模块', 'wheatv'),$widget_ops);      
	}
	
   function widget($args, $instance) {
        extract( $args );
		$num = $instance['num'];
		$title = apply_filters('widget_title', $instance['title'] );
		$category= wheatv_get_cat_slug($instance['category']);
		
		echo $before_widget;
		echo $before_title; 
		_e($title,'wheatv');
		echo $after_title;
		?>
        <div class="pop">
            	<?php
					query_posts("showposts=1&category_name=".$category);
				    while(have_posts()) : the_post(); ?>
                    <dl>
                     <?php if(has_post_thumbnail()):?>
                        <dt><a href="<?php the_permalink(); ?>" title="<?php the_title();?>"><?php the_post_thumbnail(array(50,50));?></a></dt>
                     <?php else:?>
                    <?php
                            $Content = $post->post_content;
                            $Images = '~<img [^\>]*\ />~';
                            preg_match_all( $Images, $Content, $thePics );
                            $allPics = count($thePics[0]);
                            switch ( $allPics > 0 ) {
                                case $allPics = 1;
                                echo'<dt><a href="'.get_permalink().'" class="thumbnail">'.$thePics[0][0].'</a></dt>';
                                break;
                                default:
                                echo'<dt><a href="'.get_permalink().'" class="thumbnail"><img src="'.get_bloginfo('template_url').'/images/no2.jpg" /></a></dt>';
                            };
                    ?>
                    <?php endif;?>
                        <dd>
                            <div class="poptitle"><a href="<?php the_permalink(); ?>" title="<?php the_title();?>">
					<?php the_title();?></a></div>
                            <a href="<?php the_permalink(); ?>">详细内容</a>
                        </dd>
                    </dl>
				 <?php endwhile; 
				 wp_reset_query();
				 ?>
                <div class="clear"></div>
         </div>
         <ul>
              <?php
			  query_posts("showposts=".$num."&offset=-1&category_name=".$category);
			  while (have_posts()) : the_post(); ?>
                <li><a href="<?php the_permalink(); ?>"><?php the_title();?></a></li>
              <?php endwhile;
			  wp_reset_query();
	       ?>
         </ul>
        <?php
		echo $after_widget;
   }
   
   function update($new_instance, $old_instance) {
	   $instance['category'] = strip_tags( $new_instance['category'] );
	   $instance['num'] = strip_tags($new_instance['num']);     
	   $instance['title'] = strip_tags( $new_instance['title'] );           
       return $instance;
   }
   function form($instance) {  
	   $defaults = array( 'title' => __('未指定分类名称', '未指定分类名称'),'num' => '5');
	   $instance = wp_parse_args( (array) $instance, $defaults ); 

	   $title = esc_attr($instance['title']);
	   $category = esc_attr($instance['category']);
	   $num = esc_attr($instance['num']);
   ?>
    <p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('区域标题:', 'wheatv'); ?></label>
		<input type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $title; ?>" />
	</p>
    <p>
        <label for="<?php echo $this->get_field_id('num'); ?>"><?php _e('显示文章数:','wheatv'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('num'); ?>" value="<?php echo $num; ?>" id="<?php echo $this->get_field_id('num'); ?>" />
    </p>
    <p>
            <label for="<?php echo $this->get_field_id('category'); ?>"><?php _e('所属分类:','wheatv'); ?></label>
            <select name="<?php echo $this->get_field_name('category'); ?>" class="widefat" id="<?php echo $this->get_field_id('category'); ?>">
                <?php 
				$thecatlist_A = get_categories('hide_empty=0');
                $catdlist = array();
				foreach ($thecatlist_A as $catforlist){ 
				$cate_name = $catforlist->cat_name;
				?>
                <option value="<?php echo $cate_name;?>" <?php if($category == $cate_name){ echo "selected='selected'";} ?>><?php echo $cate_name; ?></option>   
                <?php }?>       
            </select>
     </p>
   <?php
   }
}
register_widget('wheatv_category_articles');
?>