<?php
/**
 * Author Widget
 * @package WordPress
 * @subpackage runback
 */

class wheatv_author extends WP_Widget {
   function wheatv_author() {
		$widget_ops = array('description' => '显示作者头像、姓名、简介' );
		parent::WP_Widget(false, __('WheatV: 作者专栏', 'wheatv'),$widget_ops);
	}
	
   function widget($args, $instance) {
        extract( $args );
		$title = apply_filters('widget_title', $instance['title'] );
		$authorid= $instance['authorid'];
                $avtar= $instance['avtar'];
                $avtarlink= $instance['avtarlink'];
                $authorinfo= $instance['authorinfo'];
                ?>
        <div class="authorbox">
              <?php
              if($avtar<>''){
                  $avtartimg="<img src=".$avtar." name=".$name." />";
              }else{
                  if(!$authorid){$authorid=2;}
                  $avtartimg=get_avatar($authorid, 60);
              }
              if($avtarlink){
                 $link=$avtarlink;
              }else{
                 $link=get_bloginfo('url').'/?author='.$authorid;
              }
              ?>
            <a href="<?php echo $link;?>" class="alignleft widget_author"><?php echo $avtartimg;?></a>
            <h4><a href="<?php echo $link;?>" class="alignleft"><?php echo $title;?></a></h4>
            <p><?php echo $authorinfo;?></p>
            <div class="clear"></div>
        </div>
        <?php
   }
   
   function update($new_instance, $old_instance) {
	   $instance['title'] = strip_tags( $new_instance['title'] );
           $instance['avtar'] = strip_tags( $new_instance['avtar'] );
           $instance['avtarlink'] = strip_tags( $new_instance['avtarlink'] );
	   $instance['authorid'] = strip_tags($new_instance['authorid']);
           $instance['authorinfo'] = $new_instance['authorinfo'];
       return $instance;
   }
   function form($instance) {  
	   $defaults = array( 'title' => __('Author', 'Author'),'authorid' => '1');
	   $instance = wp_parse_args( (array) $instance, $defaults ); 
		
	   $title = esc_attr($instance['title']);
	   $authorid = esc_attr($instance['authorid']);
           $avtar = esc_attr($instance['avtar']);
           $avtarlink = esc_attr($instance['avtarlink']);
           $authorinfo=$instance['authorinfo'];
   ?>
    <p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('作者姓名（必填）:', 'wheatv'); ?></label>
		<input type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $title; ?>" />
    </p>
    <p>
        <label for="<?php echo $this->get_field_id('authorid'); ?>"><?php _e('作者注册ID(选填):','wheatv'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('authorid'); ?>" value="<?php echo $authorid; ?>" id="<?php echo $this->get_field_id('authorid'); ?>" />
    </p>
    <p>
		<label for="<?php echo $this->get_field_id( 'avtar' ); ?>"><?php _e('自定义头像图片地址(选填):', 'wheatv'); ?></label>
		<input type="text" id="<?php echo $this->get_field_id( 'avtar' ); ?>" name="<?php echo $this->get_field_name( 'avtar' ); ?>" value="<?php echo $avtar; ?>" />
    </p>
    <p>
		<label for="<?php echo $this->get_field_id( 'avtarlink' ); ?>"><?php _e('自定义作者页面地址(选填):', 'wheatv'); ?></label>
		<input type="text" id="<?php echo $this->get_field_id( 'avtarlink' ); ?>" name="<?php echo $this->get_field_name( 'avtarlink' ); ?>" value="<?php echo $avtarlink; ?>" />
    </p>
     <p>
		<label for="<?php echo $this->get_field_id( 'authorinfo' ); ?>"><?php _e('介绍信息(选填):', 'wheatv'); ?></label>
		<textarea id="<?php echo $this->get_field_id( 'authorinfo' ); ?>" name="<?php echo $this->get_field_name( 'authorinfo' ); ?>"><?php echo $authorinfo; ?></textarea>
    </p>
   <?php
   }
}
register_widget('wheatv_author');
?>