<?php
/**
 * Template Name: Picture News
 * @package WordPress
 * @subpackage runback
 */
?>
<?php get_header();?>
 <div id="container">
  	<div id="main">
        <div class="read"><!--recent post-->
			<?php include('page-title.php');?>
           <div class="cont">
			<?php  wheatv_postnum(get_option('picturenews_num'));?>
            <?php while(have_posts()) : the_post();?>
            	<dl>
                    <?php if(has_post_thumbnail()):?>
                     <dt><?php the_post_thumbnail(array(100,100));?></dt>
                    <?php else:?>
                    <?php
                            $Content = $post->post_content;
                            $Images = '~<img [^\>]*\ />~';
                            preg_match_all( $Images, $Content, $thePics );
                            $allPics = count($thePics[0]);
                            switch ( $allPics > 0 ) {
                                case $allPics = 1;
                                echo'<dt><a href="'.get_permalink().'" class="thumbnail">'.$thePics[0][0].'</a></dt>';
                                break; // 当图片数量有1个时，不再执行
                                default:
                                echo'<dt><a href="'.get_permalink().'" class="thumbnail"><img src="'.get_bloginfo('template_url').'/images/no.jpg" /></a></dt>';
                            };
                    ?>
                    <?php endif;?>
                    <dd>
                    	<h5><a href="<?php the_permalink() ?>" title="<?php the_title();?>"><?php the_title();?></a></h5>
                        <p><?php echo wheatv_excerpt(55); ?> </p>
                    </dd>
                </dl>
              <?php endwhile;?>
            </div>
            <?php if(function_exists('wp_pagenavi')) { wp_pagenavi(); } ?>
         </div>
    </div>
    <?php get_sidebar();?>
<?php get_footer(); ?>