<?php
/**
 * Post Loop
 * @package WordPress
 * @subpackage runback
 */
?>
<?php if (have_posts()):?>
  <?php
    if(is_home()){
	  query_posts("showposts=".get_option('blog_news_num'));
	}
  ?>
  <?php while(have_posts()) : the_post();?>
  <li <?php post_class(); ?> id="post-<?php the_ID(); ?>">
                	<h2><a href="<?php the_permalink() ?>"><?php the_title();?></a></h2>
                  <p class="postinfo"><?php the_date_xml();?> / <?php printf( __( '<span class="%1$s">分类：</span>%2$s', 'runback' ), 'entry-utility-prep entry-utility-prep-cat-links', get_the_category_list( ', ' ) ); ?> / <?php comments_popup_link(__('没有评论', 'runback'), __('1条评论', 'runback'), __('% 条评论', 'runback'), '', __('评论关闭', 'runback') ); ?></p>
                    <p class="entry">
                    <?php if(has_post_thumbnail()):?>
			  <a href="<?php the_permalink() ?>" class="thumbnail"><?php the_post_thumbnail(array(150,150));?></a>
                    <?php else:?>
                          <?php
                            $Content = $post->post_content;
                            $Images = '~<img [^\>]*\ />~';
                            preg_match_all( $Images, $Content, $thePics );
                            $allPics = count($thePics[0]);
                            switch ( $allPics > 0 ) {
                                case $allPics = 1;
                                echo'<a href="'.get_permalink().'" class="thumbnail">'.$thePics[0][0].'</a>';
                                break; 
                                default:
                               // echo'<a href="'.get_permalink().'" class="thumbnail"><img src="'.get_bloginfo('template_url').'/images/no2.jpg" /></a>';
                            };
                          ?>
                    <?php endif;?>
			  <?php echo wheatv_excerpt(200); ?></p>
                    <p class="more"><a href="<?php the_permalink() ?>">阅读更多...</a></p>
  </li>
  <?php endwhile;
   if(is_home()){
	  wp_reset_query();
	}
  ?>
<?php else:?>
  <li class="post">
      <p class="entry">Oop...没有找到任何内容</a></>
  </li>
<?php endif;?>