<?php
/**
 * Theme Functions
 * @package WordPress
 * @subpackage runback
 */

load_theme_textdomain( 'runback' );
add_theme_support('post-thumbnails');
set_post_thumbnail_size(120,120,true);
automatic_feed_links();

/*register custom menu*/
register_nav_menus(array('top_navi' => 'Top Navigation'));
register_nav_menus(array('primary_navi' => 'Primary Navigation'));
register_nav_menus(array('footer_navi' => 'Footer Navigation'));

/*register widgets*/
function wheatv_widgets_init() {
	register_sidebar(array(
		'name' => __( '全局侧栏挂件区域', 'runback' ),
		'id' => 'sidebar-widget',
		'before_widget' => '<div class="sidebox">',
		'after_widget' => '</div>',
		'before_title' => '<h5>',
		'after_title' => '</h5>',
	));
	register_sidebar(array(
		'name' => __( '单页面侧栏挂件区域', 'runback' ),
		'id' => 'page-sidebar-widget',
		'before_widget' => '<div class="sidebox">',
		'after_widget' => '</div>',
		'before_title' => '<h5>',
		'after_title' => '</h5>',
	));
	register_sidebar(array(
		'name' => __( '首页自由挂件区域1', 'runback' ),
		'id' => 'widget1',
		'before_widget' => '<div class="box">',
		'after_widget' => '</div>',
		'before_title' => '<h4>',
		'after_title' => '</h4>',
	));
	register_sidebar(array(
		'name' => __( '自由挂件区域2', 'runback' ),
		'id' => 'widget2',
		'before_widget' => '<div class="box">',
		'after_widget' => '</div>',
		'before_title' => '<h4>',
		'after_title' => '</h4>',
	));
}
add_action( 'widgets_init', 'wheatv_widgets_init' );


/*Auto Excerpt*/
function wheatv_excerpt($max_length) {
	$title_str = get_the_excerpt();
	if (mb_strlen($title_str,'utf-8') > $max_length ) {
	  $title_str = mb_substr($title_str,0,$max_length,'utf-8').'…';
	}
return $title_str;
}

/*Filter HTML*/
function regHTML($str){
  trim(strip_tags($str));
}

/*Advertisement*/
function wheatv_ad($var,$width,$height){
	$ad = get_option($var);
	$ad = trim(strip_tags($ad));
	$ad_arr = explode(',',$ad); 
	echo '<a href="'.$ad_arr[1].'" target="_blank"><img src="'.$ad_arr[0].'" alt="'.$ad_arr[2].'" border="0" style="width:'.$width.'px;height:'.$height.'px" /></a>';
}
function colorCloud($text) { 
$text = preg_replace_callback('|<a (.+?)>|i', 'colorCloudCallback', $text); 
return $text; 
} 

/*Colorful Tags cloud*/
function colorCloudCallback($matches) { 
	$text = $matches[1]; 
	$color = dechex(rand(0,16777215)); 
	$pattern = '/style=(\'|\")(.*)(\'|\")/i'; 
	$text = preg_replace($pattern, "style=\"color:#{$color};$2;\"", $text); 
	return "<a $text>"; 
} 
//add_filter('wp_tag_cloud', 'colorCloud', 1);

/*Social network icons*/
function wheatv_social(){
	if(get_option('sina')<>''){
      echo '<li class="sina"><a href="'.get_option('sina').'" title="新浪微博">新浪微博</a></li>';
	}
	if(get_option('douban')<>''){
      echo '<li class="douban"><a href="'.get_option('douban').'" title="豆瓣">豆瓣</a></li>';
	}
	if(get_option('qq')<>''){
      echo '<li class="qq"><a href="'.get_option('qq').'" title="腾讯微博">腾讯微博</a></li>';
	}
	if(get_option('kaixin')<>''){
      echo '<li class="kaixin"><a href="'.get_option('kaixin').'" title="开心网">开心网</a></li>';
	}
	if(get_option('sohu')<>''){
      echo '<li class="sohu"><a href="'.get_option('sohu').'" title="搜狐微博">搜狐微博</a></li>';
	}
	if(get_option('wangyi')<>''){
      echo '<li class="wangyi"><a href="'.get_option('wangyi').'" title="网易微博">网易微博</a></li>';
	}
	if(get_option('renren')<>''){
      echo '<li class="renren"><a href="'.get_option('renren').'" title="人人网">人人网</a></li>';
	}
}

/*Custom comments layout*/
function custom_comments($comment, $args, $depth){
  $GLOBALS['comment'] = $comment; ?>
   <li <?php comment_class('clearfix'); ?><?php if( $depth > 9){ echo ' style="margin-left:-35px;"';} ?> id="comment-<?php comment_ID() ?>">
        <div style="width:100%; overflow:hidden;">
           <?php echo get_avatar($comment,$size='30',$default='<path_to_url>'); ?>
           <div style="float:left;">
            <b><?php printf(__('%s'),get_comment_author_link());?>	 </b> 说 :<br />
                    <span class="time"><?php printf(__('%1$s at %2$s'), get_comment_date(), get_comment_time()) ?> </span>
           </div>
           <div style="clear:both;"></div>
          <p>
           <?php if ($comment->comment_approved == '0') : ?>
                        <em>
                        <?php _e('您的评论正在审核中……') ?>
                        </em> <br />
                        <?php endif; ?>
                        <?php comment_text();?>
           </p>
           <div class="reply">
			[<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>]
	   	   </div>
        </div>
    </li>

<?php }
?>
