<?php
/**
 * Theme options setting
 * @package WordPress
 * @subpackage runback
 */

// VARIABLES
$this_theme = "Runback";

/*create options*/
$options = array();
$options = array (
array("optionname" => "全局设置",
"optiontype" => "heading"),

array("optionname" => "网站风格",
"optiondescription" => "<span style=color:#999>选择相应的风格</span>",
"optionid" => "styles",
"optiontype" => "select",
"options" => $alt_stylesheets),

array("optionname" => "使用文本LOGO:",
"optionid" => "textlogo",
"optiontype" => "checkbox"),

array("optionname" => "开启Widget1区域:",
"optionid" => "widget1",
"optiontype" => "checkbox"),

array("optionname" => "开启Widget2区域:",
"optionid" => "widget2",
"optiontype" => "checkbox"),

array("optionname" => "首页设置",
"optiontype" => "heading"),

array("optionname" => "显示幻灯片:",
"optionid" => "focus",
"optiontype" => "checkbox"),

array("optionname" => "首页幻灯片分类:",
"optionid" => "focus_news_cat",
"selectoptiondef" => "All cateogries",
"optiontype" => "select",
"options" => $catdlist),

array("optionname" => "显示推荐日志:",
"optionid" => "feature",
"optiontype" => "checkbox"),

array("optionname" => "首页推荐日志数:",
"optionid" => "feature_news_num",
"optiontype" => "text"),

array("optionname" => "首页推荐日志分类:",
"optionid" => "feature_news_cat",
"selectoptiondef" => "All cateogries",
"optiontype" => "select",
"options" => $catdlist),

array("optionname" => "显示最新日志:",
"optionid" => "recent",
"optiontype" => "checkbox"),

array("optionname" => "首页最新日志数:",
"optionid" => "blog_news_num",
"optiontype" => "text"),

array("optionname" => "模板显示数量设置",
"optiontype" => "heading"),

array("optionname" => "图片模板每页显示数:",
"optionid" => "gridview_num",
"optiontype" => "text"),

array("optionname" => "列表模板每页显示数:",
"optionid" => "list_num",
"optiontype" => "text"),

array("optionname" => "图文模板每页显示数:",
"optionid" => "picturenews_num",
"optiontype" => "text"),

array("optionname" => "社会化媒体主页:",
"optiontype" => "heading"),

array("optionname" => "新浪微博:",
"optionid" => "sina",
"optiontype" => "text"),

array("optionname" => "网易微博:",
"optionid" => "wangyi",
"optiontype" => "text"),

array("optionname" => "腾讯微博:",
"optionid" => "qq",
"optiontype" => "text"),

array("optionname" => "搜狐微博:",
"optionid" => "sohu",
"optiontype" => "text"),

array("optionname" => "豆瓣主页:",
"optionid" => "douban",
"optiontype" => "text"),

array("optionname" => "开心网主页:",
"optionid" => "kaixin",
"optiontype" => "text"),

array("optionname" => "人人网主页:",
"optionid" => "kaixin",
"optiontype" => "text"),

array("optionname" => "QQ:",
"optionid" => "qqqun",
"optiontype" => "text"),

array("optionname" => "广告设置",
"optiontype" => "heading"),

array("optionname" => "头部广告468x60:",
"optiondescription" => "<p>格式（三者中间用英文逗号分隔）：图片地址,图片链接,图片描述</p>",
"optionid" => "ad468",
"selectoptiondef" => "dfas",
"optiontype" => "textarea"),
 
array("optionname" => "文章底部广告:",
"optiondescription" => "<p>格式（三者中间用英文逗号分隔）：图片地址,图片链接,图片描述</p>",
"optionid" => "pagead",
"selectoptiondef" => "dfas",
"optiontype" => "textarea"),

array("optionname" => "附加设置",
"optiontype" => "heading"),

array("optionname" => "头部附加代码:",
"optiondescription" => "<p>HTML/Javascript</p>",
"optionid" => "headercode",
"selectoptiondef" => "dfas",
"optiontype" => "textarea"),

array("optionname" => "底部附加代码:",
"optiondescription" => "<p>HTML/Javascript</p>",
"optionid" => "statisticscode",
"selectoptiondef" => "dfas",
"optiontype" => "textarea"),
);

/*Update options setting*/
function do_options_update_theme()
{
	global $this_theme, $options;
	if ( $_GET['page'] == basename(__FILE__) )
	{
		if ( 'updateoptions' == $_REQUEST['action'] )
		{
			foreach ($options as $optionvalue)
			{
				update_option( $optionvalue['optionid'], $_REQUEST[ $optionvalue['optionid'] ] );
			}
			foreach ($options as $optionvalue)
			{
					if( isset( $_REQUEST[ $optionvalue['optionid'] ] ) )
					{
						update_option( $optionvalue['optionid'], $_REQUEST[ $optionvalue['optionid'] ]  );
					}
					else
					{
						delete_option( $optionvalue['optionid'] );
					}
			}
			header("Location: admin.php?page=theme-setting.php&optionsupdated=true");
			die;
		}
	}
	add_menu_page($this_theme." 主题选项设置已保存", $this_theme." 选项", 'edit_themes', basename(__FILE__), 'do_page');
}

function do_page ()
{
	global $options, $this_theme;
?>
<div class="wrap">
  <form action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post">
    <h2><?php echo $this_theme; ?> 主题选项</h2>
    <?php if ( $_REQUEST['optionsupdated'] ) { ?>
    <?php echo "<font color=red> $this_theme 选项设置已保存。</font>";  } ?>
    <table>
      <?php
		foreach ($options as $optionvalue)
		{
			if ( $optionvalue['optiontype'] <> "heading" )
			{
?>
      <tr>
        <td height="30" width="150"><?php echo $optionvalue['optionname']; ?></td>
        <td><?php
			}
				switch ( $optionvalue['optiontype'] )
				{
					case 'text':
?>
          <input name="<?php echo $optionvalue['optionid']; ?>" id="<?php echo $optionvalue['optionid']; ?>" type="<?php echo $optionvalue['optiontype']; ?>" value="<?php if ( get_settings( $optionvalue['optionid'] ) != "") { echo get_settings($optionvalue['optionid']); } else { echo $optionvalue['optionselectoptiondef']; } ?>" />
          <?php
					break;
					case 'select':
?>
          <select name="<?php echo $optionvalue['optionid']; ?>" id="<?php echo $optionvalue['optionid']; ?>">
            <?php
					foreach ($optionvalue['options'] as $option)
					{
?>
            <option  value="<?php echo $option; ?>" <?php if ( get_settings( $optionvalue['optionid'] ) == $option) { echo ' selected="selected"'; } elseif ($option == $optionvalue['optionselectoptiondef']) { echo ' selected="selected"'; } ?>><?php echo $option; ?></option>
            <?php 
					}
?>
          </select>
          <?php
					break;
					case 'textarea':
?>
          <textarea name="<?php echo $optionvalue['optionid']; ?>" id="<?php echo $optionvalue['optionid']; ?>" cols="100" rows="8"><?php  if( get_settings($optionvalue['optionid']) != "") { echo stripslashes(get_settings($optionvalue['optionid'])); } else { echo $optionvalue['optionselectoptiondef']; } ?>
</textarea>
<?php
					break;
					case 'checkbox':
?>
         <input name="<?php echo $optionvalue['optionid']; ?>" id="<?php echo $optionvalue['optionid']; ?>" type="<?php echo $optionvalue['optiontype']; ?>" value="checked" <?php if ( get_settings( $optionvalue['optionid'] )) { echo ' checked="checked"'; } ?> />
          <?php
					break;
					case "heading":
?>
    </table>
    <h3 class="title"><?php echo $optionvalue['optionname']; ?></h3>
    <table>
      <?php
					break;
					default:
					break;
				}
?>
      <?php
				if ( $optionvalue['optiontype'] <> "heading" )
				{
?>
      <span><?php echo $optionvalue['optiondescription']; ?></span>
      </td>
      </tr>
      <?php
				}
       ?>
      <?php
			}
       ?>
    </table>
    <p class="submit">
      <input name="updateoptions" type="submit" value="保存设置" />
      <input type="hidden" name="action" value="updateoptions" />
    </p>
  </form>
</div>
<?php }
add_action('admin_menu', 'do_options_update_theme');
?>