<?php
/**
 * Theme custom field
 * @package WordPress
 * @subpackage runback
 */

//自定义填写面板
$new_meta_boxes =
array(		
	"banner" => array(
        "name" => "banner",
	"types" => "text",
        "title" => "幻灯片图片:"),
	
	"bannerlink" => array(
        "name" => "bannerlink",
	"types" => "text",
        "title" => "幻灯片外部链接(如果链接本文章，请留空)"),
);

function wheatv_new_meta_boxes() {
    global $post, $new_meta_boxes;

    foreach($new_meta_boxes as $meta_box) {
        $meta_box_value = get_post_meta($post->ID, $meta_box['name'].'_value', true);

        if($meta_box_value == "")
            $meta_box_value = $meta_box['std'];
        echo'<input type="hidden" name="'.$meta_box['name'].'_noncename" id="'.$meta_box['name'].'_noncename" value="'.wp_create_nonce( plugin_basename(__FILE__) ).'" />';
        // 自定义字段标题
        echo'<h4>'.$meta_box['title'].'</h4>';
        // 自定义字段控件
		switch($meta_box['types']){
		  case 'textarea':
            echo '<textarea cols="80" rows="3" name="'.$meta_box['name'].'_value">'.$meta_box_value.'</textarea><br />';
			break;
		  case 'text':
		    echo '<input type="text" name="'.$meta_box['name'].'_value" value="'.$meta_box_value.'" style="width:600px" /><br />';
			break;
		 case 'checkbox':
		    foreach ($meta_box['options'] as $option){
				 $checkyes = '';
				// 这里判断复选框的自定义字段值有没有 1
				if(strpos($meta_box_value, $option) !== false) {
					$checkyes = 'checked="checked"';
				}
		       echo'<input type="checkbox" name="'.$meta_box['name'].'_value[]" value="'.$option.'" '.$checkyes.' />'.$option.'&nbsp;&nbsp;';
			}
			break;
		 case 'radio':
		    foreach ($meta_box['options'] as $option){
		  ?>
		       <input type="radio" name="<?php echo $meta_box['name']?>_value" value="<?php echo $option;?>" <?php if ($option==$meta_box_value) { echo ' checked="checked"'; } ?> /> <?php echo $option; ?> &nbsp;&nbsp;
		  <?php	
            }
			break;
		}
    }
}
function wheatv_create_meta_box() {
    global $theme_name;

    if ( function_exists('add_meta_box') ) {
        add_meta_box( 'new-meta-boxes', '附加设置', 'wheatv_new_meta_boxes', 'post', 'normal', 'high' );
    }
}
function wheatv_save_postdata( $post_id ) {
    global $post, $new_meta_boxes;

    foreach($new_meta_boxes as $meta_box) {
        if ( !wp_verify_nonce( $_POST[$meta_box['name'].'_noncename'], plugin_basename(__FILE__) ))  {
            return $post_id;
        }

        if ( 'page' == $_POST['post_type'] ) {
            if ( !current_user_can( 'edit_page', $post_id ))
                return $post_id;
        } 
        else {
            if ( !current_user_can( 'edit_post', $post_id ))
                return $post_id;
        }

        //$data = $_POST[$meta_box['name'].'_value'];
		if ($meta_box['types'] == 'checkbox' && is_array($_POST[$meta_box['name'].'_value'])) {
            // 自定义字段不能保存数组，所以这里用逗号将各个值隔开
			$data = implode(",",$_POST[$meta_box['name'].'_value']);
		}else {
			$data = $_POST[$meta_box['name'].'_value'];
		}

        if(get_post_meta($post_id, $meta_box['name'].'_value') == "")
            add_post_meta($post_id, $meta_box['name'].'_value', $data, true);
        elseif($data != get_post_meta($post_id, $meta_box['name'].'_value', true))
            update_post_meta($post_id, $meta_box['name'].'_value', $data);
        elseif($data == "")
            delete_post_meta($post_id, $meta_box['name'].'_value', get_post_meta($post_id, $meta_box['name'].'_value', true));
    }
}
add_action('admin_menu', 'wheatv_create_meta_box');
add_action('save_post', 'wheatv_save_postdata');
?>