/*
Feature: SubMenu
*/

var Class = {
	create: function() {
		return function() {
			this.initialize.apply(this, arguments);
		}
	}
}

var SubMenu = Class.create();
SubMenu.prototype = {

	initialize: function(id, opacity) {
		this.obj = document.getElementById(id);
		if (!this.obj) { return; }

		var menus = this.obj.getElementsByTagName('ul');
		for (var i = 0; i < menus.length; i++) {
			var menu = menus[i].parentNode;
			if(menu.parentNode === this.obj) {
				new Menu(menu, opacity);
			} else {
				new Menu(menu, opacity, 1);
				menu.firstChild.className += ' subtitle';
			}
		}
	}
}

var Menu = Class.create();
Menu.prototype = {

	initialize: function(target, opacity, sub) {
		this.util = new MenuItem();

		this.obj = this.util.cleanWhitespace(target);

		this.opacity = opacity || 1;

		this.sub = sub || -1;

		this.menu = this.obj.childNodes

		if (this.menu.length < 2) { return; }


		this.title = this.menu[0];
		this.body = this.menu[1];


		this.util.setStyle(this.body, 'visibility', 'hidden');
		this.util.setStyle(this.body, 'position', 'absolute');

		this.util.setStyle(this.body, 'display', 'block');

		this.addListener(this.obj, 'mouseover', this.util.bind(this, this.activate), false);
		this.addListener(this.obj, 'mouseout', this.util.bind(this, this.deactivate), false);
	},

	activate: function() {

		if(this.sub == 1) {
			var pos = this.util.currentOffset(this.title);
			var left = this.util.getWidth(this.body);
			var top = pos[1];

		} else {
			var pos = this.util.cumulativeOffset(this.title);
			var left = pos[0];
			var top = pos[1] + this.util.getHeight(this.title);
			this.util.setStyle(this.body, 'opacity', this.opacity);
		}

		this.title.className += ' current';

		this.util.setStyle(this.body, 'left', left + 'px');
		this.util.setStyle(this.body, 'top', top + 'px');
		this.util.setStyle(this.body, 'visibility', 'visible');

	},

	deactivate: function(){

		this.util.setStyle(this.body, 'visibility', 'hidden');

		this.title.className = this.title.className.replace('current', '');
	},


	addListener: function(element, name, observer, useCapture) {
		if(element.addEventListener) {
			element.addEventListener(name, observer, useCapture);
		} else if(element.attachEvent) {
			element.attachEvent('on' + name, observer);
		}
	}
}

var MenuItem = Class.create();
MenuItem.prototype = {
	initialize: function() {
	},

	$: function(id) {
		return document.getElementById(id);
	},

	$A: function(iterable) {
		if(!iterable) {
			return [];
		}
		if(iterable.toArray) {
			return iterable.toArray();
		} else {
			var results = [];
			for(var i = 0; i < iterable.length; i++) {
				results.push(iterable[i]);
			}
			return results;
		}
	},

	bind: function() {
		var array = this.$A(arguments);
		var func = array[array.length - 1];
		var _method = func, args = array, object = args.shift();
		return function() {
			return _method.apply(object, args.concat(array));
		}
	},

	getHeight: function(element) {
		return element.offsetHeight;
	},

	setStyle: function(element, key, value) {
		element.style[key] = value;
	},

	getStyle: function(element, key) {
		return element.style[key];
	},

	cleanWhitespace: function(list) {
		var node = list.firstChild;
		while (node) {
			var nextNode = node.nextSibling;
			if(node.nodeType == 3 && !/\S/.test(node.nodeValue)) {
				list.removeChild(node);
			}
			node = nextNode;
		}
		return list;
	},

	cumulativeOffset: function(element) {
		var valueT = 0, valueL = 0;
		do {
			valueT += element.offsetTop  || 0;
			valueL += element.offsetLeft || 0;
			element = element.offsetParent;
		} while (element);
		return [valueL, valueT];
	},

	getWidth: function(element) {
		return element.offsetWidth;
	},

	currentOffset: function(element) {
		var valueT = element.offsetTop  || 0;
		var valueL = element.offsetLeft || 0;
		return [valueL, valueT];
	}

}

window.onload = function(e) {
	new SubMenu('primary-menu', 1);
}
