<?php
/**
 * @package WordPress
 * @subpackage runback
 */

// Do not delete these lines
	if (isset($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');
	
	if ( post_password_required() ) { ?>
		<p class="nocomments"><?php _e('This post is password protected. Enter the password to view comments.', 'runback'); ?></p> 
	<?php
		return;
	}
?>

<!-- You can start editing here. -->

<?php if ( have_comments() ) : ?>
	<h3 id="comments"><?php comments_number(__('没有评论', 'runback'), __('1条评论', 'runback'), __('% 评论', 'runback'));?> <?php printf(__('to &#8220;%s&#8221;', 'runback'), the_title('', '', false)); ?></h3>

	<div class="navigation">
		<div class="alignleft"><?php previous_comments_link() ?></div>
		<div class="alignright"><?php next_comments_link() ?></div>
	</div>

	<ol class="commentlist" style="list-style-type: none;">
    <?php global $comment_ids; $comment_ids = array();
		foreach ( $comments as $comment ) {
		if (get_comment_type() == "comment") {
		$comment_ids[get_comment_id()] = ++$comment_i;}
	} ?>
	<?php wp_list_comments('type=comment&callback=custom_comments&t&max_depth=10000');?>
	</ol>

	<div class="navigation">
		<div class="alignleft"><?php previous_comments_link() ?></div>
		<div class="alignright"><?php next_comments_link() ?></div>
	</div>
 <?php else : // this is displayed if there are no comments so far ?>

	<?php if ( comments_open() ) : ?>
		<!-- If comments are open, but there are no comments. -->

	 <?php else : // comments are closed ?>
		<!-- If comments are closed. -->
		<p class="nocomments"><?php _e('评论关闭', 'runback'); ?></p>

	<?php endif; ?>
<?php endif; ?>


<?php if ( comments_open() ) : ?>

<div id="respond">

<h3><?php comment_form_title( __('评论', 'runback'), __('关于%s的评论' , 'runback') ); ?></h3>

<div id="cancel-comment-reply"> 
	<small><?php cancel_comment_reply_link() ?></small>
</div> 

<?php if ( get_option('comment_registration') && !is_user_logged_in() ) : ?>
<p><?php printf(__('你必须先<a href="%s">登录</a>', 'runback'), wp_login_url( get_permalink() )); ?></p>
<?php else : ?>

<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">

<?php if ( is_user_logged_in() ) : ?>

<p><?php printf(__('<a href="%1$s">%2$s</a> 已登录.', 'runback'), get_option('siteurl') . '/wp-admin/profile.php', $user_identity); ?> <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="<?php _e('退出', 'runback'); ?>"><?php _e('退出 &raquo;', 'runback'); ?></a></p>

<?php else : ?>

<p><input type="text" name="author" id="author" class="input" value="<?php echo esc_attr($comment_author); ?>" size="22" tabindex="1" <?php if ($req) echo "aria-required='true'"; ?> />
<label for="author"><?php _e('姓名', 'runback'); ?> <?php if ($req) _e("(必填)", "runback"); ?></label></p>

<p><input type="text" name="email" id="email" class="input" value="<?php echo esc_attr($comment_author_email); ?>" size="22" tabindex="2" <?php if ($req) echo "aria-required='true'"; ?> />
<label for="email"><?php _e('电子邮箱 (不会公开)', 'runback'); ?> <?php if ($req) _e("(必填)", "runback"); ?></label></p>

<p><input type="text" name="url" id="url" class="input" value="<?php echo  esc_attr($comment_author_url); ?>" size="22" tabindex="3" />
<label for="url"><?php _e('网址', 'runback'); ?></label></p>

<?php endif; ?>

<!--<p><small><?php printf(__('<strong>XHTML:</strong> You can use these tags: <code>%s</code>', 'runback'), allowed_tags()); ?></small></p>-->

<p><textarea name="comment" id="comment" cols="58" rows="10" tabindex="4"></textarea></p>

<p><input name="submit" type="submit" id="submit" class="commentbtn" tabindex="5" value="<?php _e('提交评论', 'runback'); ?>" />
<?php comment_id_fields(); ?> 
</p>
<?php do_action('comment_form', $post->ID); ?>

</form>

<?php endif; // If registration required and not logged in ?>
</div>

<?php endif; // if you delete this the sky will fall on your head ?>
